# Experiments

## Tachyon Experiment Basics

Tachyon applications are server side rendered apps that return pages that are
potentially cached. Experimenting directly on device ID can result in
cache-poisoning since a treatment user could wind up being served a cached
control version of an experiment. Instead, we transform device IDs into one of 9
"buckets" (up to 3 concurrent experiments per app) and then use that experiment
bucket as a cache key. This enables us to cache pages with their proper
experiment outcomes, with high cache rates, while preventing cache-poisoning /
experiment group leakage.

Experiment bucket assignment takes place in VCL code run in the Fastly CDN,
where un-cookied requests are assigned a device ID. Device IDs are turned into
bucket IDs using the same algorithm as `generateExperimentBucketFromDeviceID`
from `tachyon-server-utils` and then that bucket ID is sent from the CDN to the
Tachyon server using a custom `x-bucket-id` request header.

## Creating and Running a New Experiment

Creating the new experiment:

1. Go to the Minixperiment
   [creation](https://minixperiment.di.xarth.tv/admin#/experiment/new) page.
1. For "Name" prefix your experiment name with its corresponding app prefix
   (tmw,sst,vlc). For example "sst-qrcode-color".
1. For "Publish to" select "Tachyon".
1. For "Editing Groups" add "mobileweb".
1. For "Value" add two entries: "control" and "treatment".
1. For "Weight" enter "0", "50" or "100".

[Register the experiment](../packages/tachyon-core/experiments/README.md#registering-the-experiment)
using the tachyon-experiments package

## Local overrides for development

Tachyon applications support the ability to override assigned experiment groups
for testing purposes in any environment. This is accomplished using the
`experiment_overrides` URL query parameter:

```
https://<tachyon-app-url>?experiment_overrides=<UUID>=<control|treatment>
```

Note: overrides only work in non production environments (staging and
development).

You can override multiple experiment assignments at a given time using the same
approach:

```
https://<tachyon-app-url>?experiment_overrides=<UUID1>=<control|treatment>&experiment_overrides=<UUID2>=<control|treatment>
```

## Running Localized Experiments

To run a localized experiment you can wrap the `<Experiment>` component in a
`<LocaleGate>`.

```tsx
import type { FC } from 'react';
import {
  ExperimentName,
  Experiment,
  Treatment,
  ExperimentGroup,
} from 'tachyon-experiments';
import { CountryCode } from 'tachyon-intl';

const experimentCountryCodes = [CountryCode.Brazil, CountryCode.Mexico];

const ControlComponent = () => <div>Control</div>;
const TreatmentComponent = () => <div>Treatment</div>;

const LocalizedExperimentContainer: FC = () => (
  <LocaleGate
    countries={experimentCountryCodes}
    fallback={<ControlComponent />}
  >
    <Experiment experimentUUID={'<SOME-EXPERIMENT-UUID>'}>
      <Control>
        <TreatmentComponent />
      </Control>
      <Treatment>
        <ControlComponent />
      </Treatment>
    </Experiment>
  </LocaleGate>
);
```

## FAQ

### Can I imperatively get the user's experiment assignment?

No. That approach can cause accidental assignment and hard to reason about
experiment design. Use the provided `<Experiment>` and `<Treatment>` components
wherever necessary. The Emerging Platforms team is happy to help you find a path
forward for more challenging experiment designs within this system.

### Why do my experiment enrollment distributions not exactly match my configuration weightings?

As mentioned previously, we use an [Experiment Bucket](#experiment-buckets)
system to determine user experiment group enrollment. This can cause weightings
to be off as much as 5% for a 50 / 50 experiment.

Multiple A/A experiments have been performed to ensure that this creates no
adverse effects on experiment results:

- https://expo.osiris.xarth.tv/experiments/1624c168-6f83-421f-90a6-3c0d0be252b9/1/2019-09-10/2019-11-05
- https://expo.osiris.xarth.tv/experiments/a3c18184-3e25-42f1-aafe-8cc16b0faf76/1/2019-09-10/2019-11-05

### Can I reroll group assignments / shuffle IDs using Minixperiment?

No. Due to the afformentioned experiment bucketing strategy that involves the
CDN, we do not support this Minixperiment feature. Instead, create a new
experiment with the same configuration and update the implementation to the new
ID.
