# Dependency Upgrades

## Overview

Emerging Platforms team Responsibilities:

- All dependency upgrades are triaged on a weekly basis as part of the on-call
  rotation process
- Minor upgrades will be completed within one week of being triaged
- Major upgrades will be completed within 4 weeks of being triaged, or will be
  filed with the appropriate team if the change falls to a separate package
  maintainer.

Package Owner Responsibilities:

- Major upgrades will be completed within 4 weeks starting from the time that
  the Emerging Platforms team opens the upgrade management ticket. Teams that
  fail to deliver this on time will have their package decoupled from Mobile
  Web's rolling dependency management and will be responsible for managing this
  themselves.

## Background

Keeping dependencies updated is important from two perspectives:

- If a consumer needs to use a newer feature in a newer release of a library,
  having that dependency up to date reduces friction. This is especially true
  for React applications as best practices are constantly evolving, and being up
  to date with React allows developers to transition as soon as possible. For
  instance, the deprecation of lifecycle methods involves new replacements and
  allowing developers to start using the new versions prevents further creation
  of tech debt upon writing.

- Security vulnerabilities can be found in libraries that necessitate a quick
  upgrade, and always being up-to-date minimizes the possible friction to
  adopting a security-related version update (such as the React 16.4.2 SSR fix
  release).

These angles combine to make updating a necessity for the application.
Additionally, smaller, more frequent update passes reduce the burden of the
work, as opposed to large, infrequent passes that can require lots of code
changes to accommodate any API changes in dependencies. This all informs the
following policy.

Since security is one of the important reasons behind this policy, we take
inspiration from security research efforts like Google's Project Zero. This
means this policy calls out a strict timeline for the general upgrade case.
Understanding that sometimes things can be more difficult than the normal case,
it is possible to get case-by-case extensions but this must be accompanied by
documented efforts to actively solve the issue and a timeline for expected
resolution.

## Detailed Policy

The mobile web platform team will attempt to update all dependencies every week
as part of their on-call rotation per the following procedure:

1. Running `yarn outdated` to determine what packages have pending updates.
1. Running `yarn upgrade package` to update each package and its
   subdependencies. For minor and major upgrades, the updater will read the
   changelog to look for anything of note. After each package is updated, the
   entire CI suite should still pass and all pages should still work during a
   quick run-through.
1. After all packages are updated, the updater will run `yarn upgrade` to ensure
   all sub-dependencies are bumped and will then inspect the main app's bundle
   to ensure that the upgrade has not introduced any package duplication or
   other bundle size regressions.

For any packages that break tests (or the site on a run-through), the updater
will triage the situation to determine the course of action. For things that are
platform-related and small, fixing affected code and/or tests will be considered
part of the weekly update work. Platform-related work would include things like
updates flowing from new types definitions for a library, but would not cover
logical code.

For larger conflicts and non-platform-owned code, that work will be captured
into a ticket.

- The mobile web platform team will work to close its own tickets by the end of
  the following sprint, resulting in a general time to resolution of 4 weeks.
- For code in packages not maintained by the Emerging Platforms team, owning
  teams will be expected to be on the same 4-week timeline if they want to
  continue receiving package support from the Emerging Platforms team.
  Otherwise, they can move to pinned version dependencies and take over the
  platform-provided maintenance (or establish a rectification plan as described
  below).
- For in-app code not owned by the platform team, owning teams will be expected
  to be on the same 4-week timeline since it is vital not to block other teams
  in a shared application. If a team can't fix the issue in this timeframe, they
  can extract their logic into a team-maintained package (or establish a
  rectification plan as described below).

In the case of extenuating circumstances such as especially difficult upgrades,
a longer timeline can be granted on a case-by-case basis, but these must include
detailed rectification timelines and documentation of on-going efforts.

For any upgrades that result in failing tests or site regressions, any code
updates should include tests to protect against future issues.
