# Feature Ownership in Tachyon

The Tachyon monorepo houses multiple apps and packages which share an underlying
platform, CI, and infrastructure. They each have different ownership policies
based on their contribution models.

## Apps

### Tomorrow (Mobile Web)

Tomorrow is open to contribution from all teams at Twitch. The Core Platforms
team within Emerging Platforms can provide guidance and advice to help develop
new features, but the contributing team will retain responsibility for that
functionality as it goes into production. Currently, Core Platforms is the
first-line on-call for issues arising in production for Tomorrow, but
contributing teams must have an on-call available to which to redirect
issues/reports/sevs as necessary (including any long-term rectification and
postmortem responsibilities). This also includes any work to support dependency
upgrades per the [Dependency Upgrade Policy](./dependency-upgrades.md).

### Starshot (Web TV)

Starshot is developed by the Living Room team within Emerging Platforms (with
platform support from Core Platforms), and they retain responsibility for the
app and its related launchers.

### Valence (Custom Web Embed)

Valence is developed by the Core Platforms team with Emerging Platforms, and
they retain full responsibility for the app and interacting with its customers.

### Moonbase (Appeals Portal)

Moonbase is developed by the Trust & Safety team (with platform support from
Core Platforms) and they retain responsibility for the app, including any work
to support dependency upgrades per the
[Dependency Upgrade Policy](./dependency-upgrades.md).

## Packages

### Core Packages

The Core Platforms team within Emerging Platforms handles primary responsibility
for the `tachyon-core/` and `pulsar/` package directories. Contributions are
welcome but ownership will transfer to Core Platforms upon approval; as a
result, these contributions will have to meet Core Platforms' standards for
testing and coverage, coding patterns, and any migration or mitigation work
(e.g. writing lint rules) to ensure satisfaction with what they will be
maintaining.

### Team-based Packages

The remaining packages are segmented into team-based package directories. These
will be owned by the corresponding teams, though the Core Platforms team within
Emerging Platforms can advise on structure and other best practices as
necessary. The owning team is expected to be able to respond to any
issues/reports/sevs as necessary (including any long-term rectification and
postmortem responsibilities). This also includes any work to support dependency
upgrades per the [Dependency Upgrade Policy](./dependency-upgrades.md).
