# Filing Tickets Against Tachyon

Tachyon operates under the "EMP" (for Emerging Platforms) project in
[Jira](https://jira.xarth.tv/). This details necessary usage beyond
Twitch-standard mandatory fields.

## Important Fields

### Issue Type

Bug reports default to Sev-5 Bug issues (especially if they are found in dev),
unless there is measurable business impact. This is especially true for
Starshot-related issues, as our QA team will verify all resolved bug tickets as
part of the pre-release validation process.

### Due Date

The due date is used for pre-arranged work (via the quarterly roadmap planning
process) or high severity bugs.

### Summary

The summary should include the app or package that is relevant to the ticket.

### Description

The description should include as much info as possible: examples, repro steps
(mandatory for bugs), prior art, inspiration, etc. It's fine to include links to
GitHub or other sites if that would help convey context but because Slack is not
always stable (depending on the retention policy of the channel in which a
discussion took place), it is necessary to quote relevant parts of a Slack
discussion because Slack conversations are not always retained or visible
(though still include a link as well).

### Linked Issues

Any related issues (especially blockers or things blocked) should be linked with
the appropriate link type.

## After Creation

Call out the ticket in a public channel to ensure that an EMP manager or senior
engineer sees the issue. They will then triage the ticket to verify the info,
assign it to the proper sub-team (via the label field), and properly prioritize.
