# Working with Git in Tachyon

We use [husky.js](https://github.com/typicode/husky) to add git hooks to the
repo in order to provide some uniformity on branch names and commit messages.

## Default Branch

Tachyon's default git branch is `main`.

## Branch Names

Branch names must begin with a scope indicating your name somehow. This can be
your first name, your Twitch login, or anything that people would recognize to
identify you. For example:

- derek/branch
- dowderek/another-branch
- therealderekt/yet-another-branch

## Commit Messages

Commit messages have a specific format that allow us to easily parse changesets
when deploying various applications within the monorepo.

Commit messages are linted by [commitlint](https://commitlint.js.org/) (via
husky), following the conventional-commit standard (omitting body and footer).

Commit messages must start with a type, which must be one of the following
values (from conventional-commit):

- build: Affects the build system or external dependencies
- chore: Other changes that don't modify src or test files
- ci: Changes CI configuration files and scripts
- docs: Adds or alters documentation
- feat: Adds a new feature
- fix: Solves a bug
- perf: Improves performance
- refactor: Rewrites code without feature, performance or bug changes
- revert: Reverts a previous commit
- style: Improves formatting, white-space
- test: Adds or modifies tests

The type must then be follow by a scope in parentheses, which must correspond to
the affected package(s). We strip leading `tachyon-` prefixes from the packages
names in order to reduce the namespace noise, and there is an added `repo` scope
for repo-wide changes such as dependency upgrades or config updates.

The commit message itself must be at least 15 characters long (a somewhat
arbitrary number chosen to help ensure meaningful commit messages).

For example:

- ci(repo): update commitlint rules
- refactor(tomorrow-app): convert all pages to FC components
- feat(laser-array-app,starshot-app): prepare for next LG release

### Commit Message CLI

There is an interactive prompt version of commitlint available via `yarn commit`
that features lists and autocomplete of the various config choices. This can
make it much easier for you to generate messages that conform to the lint rules.
It currently does not support multi-scope message generation, so those rare
cases will need to be created or updated/amended by hand.

## Merges

The above rules (especially the ones around commit messages) are meant to make
it easier to review the main commit line for understanding relevant changes
during deploys and publishes. Along these same lines, we perform master merges
via the squash-and-rebase strategy, ensuring atomic commits that are easily
understandable. With this in mind, feel free to use whatever in-branch commit
strategy you prefer (squashed/amended commits, micro-commits, etc). Just ensure
that your PR name contains all relevant scopes so that that information is
preserved in the final squash commit.
