# Test Coverage in the Tachyon Repo

Our test policy strives to enable developers to spend time writing only
meaningful tests and give us confidence in our test coverage numbers:

- All non-trivial production critical paths and behaviors must be unit tested
  for a given file
- All bug fixes must include regression unit test cases
- Trivial production code and test utilities must not be tested and must be
  explicitly excluded from test coverage

## Trivial Production Code

Production functions and Components that do not have dynamic logic or outputs
and already have strong contract guarantees due to TypeScript must not be
tested. This reduces long-term refactoring overhead, helps maintain test suite
performance, and prevents low-value "snapshot" style testing.

Examples include:

- Trivial presentation React Components
- HOC / Custom Hooks that only return a Context
- Trivial wrappers around Browser APIs to simplify test mocking
  (`i.e. isBrowser()`)

## Testing Test Helpers

We don't expect test coverage for non-production code meant solely to aid in
testing such as mocks or scaffolding utilities.

## Excluding Trivial Code From Test Coverage With Istanbul

Using the criteria above, you can exclude a code block from test coverage using
`// istanbul ignore next: <reason>`:

```ts
// istanbul ignore next: trivial
export function hasBrowserFeature(): boolean {
  return 'SomeFeature' in window;
}
```

## Checking Test Coverage Locally

Running `yarn test:coverage` from within any app or package will run all tests
and open a view where you can view the output code coverage.
