# Using dangerousySetInnerHTML

React's `dangerousySetInnerHTML` API is true to its name, but its usage is
sometimes necessary. To help prevent the introduction of security
vulnerabilities, usage of this API is tightly monitored within the Tachyon repo.

## Policy

In order to use this API, you'll need to consult with the Emerging Platforms
team to get a review of your usage to ensure that it's not exposing
user-generated or other potentially problematic content that could result in
cross-site scripting or other attacks. This might result in the EMP team
requesting that you get a security review before proceeding if it's not trivial
to determine that the use-case is safe.

## Enforcement

The
[react/no-danger](https://github.com/yannickcr/eslint-plugin-react/blob/master/docs/rules/no-danger.md)
lint rule is activated throughout the repo; this prevents general usage of the
API. We've also disabled ESLint magic comments that disable this rule, to
prevent easily working around this restriction. Once the Emerging Platforms team
is satisfied with the safety of your feature, your file can be added to the
appropriate allowlist so that you can proceed.
