# Working in packages

## Change Tracking

The tachyon monorepo publishes all of its packages simultaneously, and at
publish time it can be hard to understand the scope of all pending changes. As a
result, we have a live [CHANGELOG](../CHANGELOG.md) that should include short
descriptions and a PR link for all package changes. This should be updated as
part of any PRs that involve packages. Each relevant package is given its own
section, and the packages should appear alphabetized for ease of scanning.

The next pending version number will always default to a patch release after
each publish. If the scope of your changes merits a minor or major version bump,
upgrade the next pending version number accordingly.

_NOTE:_ You do not need to update the CHANGELOG for any packages that are marked
as private as they are not published. See below for more details.

## Private Packages

### Internal Rebuilds

Some of the libraries we use were not published in a way that was convenient for
us to consume. This can include awkward typings, specific webpack
dependencies/opinions, or merely having been published as raw ES2015+.

These packages are private because they exist to fix these types of issues:

- tmi

## In-development Packages

Some of our packages will eventually be fine for public distribution and will
eventually be published, but while they are pre-1.0 they might have a lot of
thrash that could both frustrate consumers (unnecessarily increasing our support
requirements) and also wreck our repo-wide semantic versioning.

Add `"private": "true"` to the `package.json` file to prevent it from being
published.

## Private Packages

Some of our packages are truly for in-monorepo use, as they may be hard-coded to
work with values relevant specifically to Emerging Platforms or are not built to
the standards required for supporting public distribution.

These packages are private without justification:

- tachyon-debug-reporter
- tachyon-next-types
