# Managing Tachyon App Bundle Sizes

## Performing App Bundle Size Analysis

### Basic Bundle Analysis With Prodlike Builds

Running `yarn prodlike` for an application will create a production like build
with [tree-shaking](https://webpack.js.org/guides/tree-shaking/) and
[code-splitting](https://nextjs.org/blog/next-9-2#improved-code-splitting-strategy).

Next will output the calculated bundle Size for each page and shared bundle as
part of the `prodlike` command. Next will also calculate the entire amount of JS
that would need to be downloaded when visiting a page directly without any prior
client asset caching ("First Load JS").

General rules of thumb:

- Individual page bundle sizes should be in the 3-40kB range

- First Load JS for pages should be in the 250-350kB range

If there are any bundles that exceed these expectations, proceed to the section
below to better understand the bundle's size.

### Advanced Analysis With Bundle Analyzer

A Tachyon application's build bundles can analyzed by running `yarn analyze`
from within the application directory.

This command will perform a prodlike build of the application and run
[webpack-bundle-analyzer](https://www.npmjs.com/package/webpack-bundle-analyzer)
on it through
[@next/bundle-analyzer](https://www.npmjs.com/package/@next/bundle-analyzer).

This is particularly helpful for determining:

- The primary contributors to bundle size

- Unexpected inclusions of non-production dependencies (Jest, Faker, etc)

- Dependencies that are not tree-shaking properly or at all

- Opportunities to introduce deferred loading of dependencies that are not
  required on page load

### Interpreting Bundle Analyzer Output

The analyzer command will open two browser tabs containing the interactive
output.

1. `client.html` - these bundle sizes correspond to the output seen in the
   `yarn prodlike` command.

1. `server.html` - contains server bundle sizes.

Refer to webpack-bundle-analyzer's
[Size Definitions](https://github.com/webpack-contrib/webpack-bundle-analyzer#size-definitions)
to understand how to navigate the analyzer outputs.

## Improving First Load JS Page Sizes

- Use
  [Dynamic Imports](https://nextjs.org/docs/advanced-features/dynamic-import) to
  defer the loading of any page dependencies that are not critical to creating
  an interactive page at load.
