# Debugging HLS Content

There are a number of reasons why it may be useful to probe HLS (Live Channel &
VODs) content:

1. Determining if there are common characteristics for content that does and
   does not play on certain devices.

2. Checking for content specific issues.

## How To Probe HLS Content

We will use Apple's
[HLS Live Stream Tools](https://developer.apple.com/documentation/http_live_streaming/about_apple_s_http_live_streaming_tools).

This will:

- print out underyling information about the stream
- print out any HLS violations or potentially fatal issues with the content (IVS
  has a number of
  [known issues](https://docs.google.com/document/d/1n1qcpMDrLgl1AorGojNm_WVOhNvZBC5jID70JFjxzlo/edit)).

### How To Use

1. Create a free [Apple Developer](https://developer.apple.com/) personal
   account. You are not required to purchase the Apple Developer Program for
   this.

2. [Download](https://developer.apple.com/download/all/?q=HLS) and install the
   HLS streaming tools.

3. Open a Tachyon app and get a fully formed main manifest url. (search for
   "usher" under the Network tab in the Dev Tools)

4. Run `mediastreamvalidator -O <json-filename>.json`. Allow this command to
   execute for at least a minute or two.

5. You can safely cancel / exit (ctrnl-c) at any time while
   `mediastreamvalidator`is running and it will print out its audit and the HLS
   content's metadata.

6. Run `hlsreport -o <html-filename>.html <json-filename>.json` to get a human
   readable HTML report.
