# GQL Partial Success Tuning

It is important to make our pages and features resilient to GraphQL query
responses that are missing some portion of the expected fields typically due to
one or more backend service outages.

## Testing Service Failures In Your Application

**Ensure you are on Amazon VPN (Cisco)** otherwise GQL will error when we make
requests to it with debug mode / service failure headers.

### Determining Query Service Dependencies

1. Open your application's `gql.ts` file. It should be located at
   `<tachyon_root>/app/<app_name>/src/config/gql.ts`

2. Set `GQL_DEBUG_MODE` to `true`.

3. Run the application with `yarn start`.

4. Check the Developer Console logs for a `logServicesFromResponse` log. The
   services will be listed in the `context.services` object.

### Testing Query Partial Response Handling

1. Open your application's `gql.ts` file. It should be located at
   `<tachyon_root>/app/<app_name>/src/config/gql.ts`.

2. Add the name of the query (or queries) used by the page you want to test to
   the `ALLOWED_PARTIAL_RESPONSE_QUERIES` array.

3. Add the dependent services to the `FAIL_SERVICES` array, then comment them
   all out to start with.

4. Start your app with `yarn start`, then one by one, uncomment a single service
   at a time from the services array, and observe how the page is rendered when
   that service fails. You may want to take a screenshot of your page for each
   service, as well as a screenshot of what your page looks like with no failing
   services to help you compare.

5. Make any changes as necessary to ensure the user gets the best possible
   degraded experience.

6. Repeat steps 4 and 5 for each backend service that your page relies upon.
