# Static Assets

Tachyon applications can serve Static assets via
[Next's static file serving](https://nextjs.org/docs/basic-features/static-file-serving)
or via AWS S3 through vicarious. In both cases, these static assets reside in
the applications `public` folder.

In general, static assets should be uploaded to AWS S3 and served through
vicarious. Tachyon applications share a single AWS S3 bucket, so static assets
should prefixed with the application name.

## Adding new static assets

Note: Eventually we will have consistent handling across applications.
Individual differences are called out here until then.

### Tomorrow

1. Add file(s) to the `public/static` folder.
1. Deploy the application (or run the `Static Asset Deploy` to only deploy asset
   changes).

### Starshot

1. Add file(s) to the `public/static/starshot` folder.
1. Deploy the application (or run the `Static Asset Deploy` to only deploy asset
   changes).

### Valence

Not yet implemented.

### Sky Map

Not yet implemented.

### Status

Not yet implemented.

## Static Assets Served via Next.js

1. robots.txt
1. service-worker.js (mobile web only)
