# Testing Packages Outside of the Monorepo

The majority of package development is done inside the monorepo, working against
tests and package examples to build an app-agnostic interface that ensures
portability and reusability. But sometimes it can be useful to do verification
of a near-finished implementation against an external app. There are a couple of
options to accomplish this.

## yarn link

`yarn link` is a method of having yarn mediate package-linking between local
repos. It can work fine for simple JS packages, but has known issues with
monorepos, TypeScript, and many other advanced setups. As a result is it not
recommended to try to use this at all.

## yalc

[`yalc`](https://www.npmjs.com/package/yalc) is a tool that mimics publishing,
sending only a package's target published artifacts to a local cache. This
allows consuming applications to link against the solely same artifacts that
would come from a registry, preventing confusion around TypeScript versions,
etc.

### Usage

You can read the `yalc` docs for more details, but these steps will work for
most use-cases.

#### Setup

First you'll need to have `yalc` installed globally:

```sh
yarn global add yalc
```

#### Publishing

From within the package you want to use externally, you'll need to "publish" the
changes to your local cache (you'll always need to ensure that you've built the
latest changes to produce updated artifacts):

```sh
yarn build && yalc push
```

_Note: we use `push` instead of `publish` because it forces all dependents to
update to the new changeset. This isn't strictly necessary for the first linkage
but it's easier to just always use `push`._

#### Linking

From within the app you want to test with the new changes, you'll need to add a
new source for the target dependency:

```sh
yalc add <target-dependency-name>
```

This will alter your package.json to use a `file:`-based version for the
dependency, as well as adding some related files (`.yalc/` and `yalc.lock`)
which you can add to `.gitignore` for convenience if this linkage-testing will
be a common occurrence (but this isn't mandatory as `yalc` will clean up after
itself when you unlink).

#### Updating

As you do more dev in the source package, you can re-run the publish commands to
propagate updates:

```sh
yarn build && yalc push
```

The usage of `push` here is important because it updates all dependents
immediately. Depending on your bundler configuration, the application might
recognize that the dependency has changed and rebuild (both Next.js and
Create-React-App support this and will reload automatically, for example). If
the app's bundle config does not support this, you'll need to force a rebuild
accordingly.

#### Unlinking

Once you're done testing the integration, you can reset all of the `yalc`
changes by simply removing the dependency:

```sh
yalc remove <target-dependency-name>
```

`yalc` uses `yalc.lock` to cache the overwritten version, so it's able to reset
everything to the way it was before linking while also preserving any other code
changes you made in response to the new version of the source package.

## Pre-release publishing

It's possible to publish a pre-release version of a package for a more final
integration verification (similar to how Core UI releases work). If you'd like
help with that, contact the Emerging Platforms team for assistance.
