# Upgrading Player-Core

## Setup

Follow the [Getting Started](../README.md#getting-started) guide.

## Update Player-Core in Tachyon-Player-Core-Loader

1. Bump the Player-Core version in `pulsar-player-core`'s
   [package.json](../packages/pulsar/player-core/package.json).
1. Bump the Player-Core version in Pulsar's Example app
   [package.json](../package-examples/pulsar-core/package.json).
1. Run `yarn install` from the repo root.

## Prepare A Pull Request

1. Run `yarn install && yarn build && yarn typecheck` from the root of Tachyon
   to see if there are any breaking type changes.
1. Make any necessary changes.
1. Open a Pull Request named "Player-Core v<SemVer>" with the changes in the
   [Tachyon](https://git.xarth.tv/emerging-platforms/tachyon) GHE Project.
1. Apply the "Blocked" label.
1. Once the QA process has been completed, remove the "Blocked" label and apply
   the "Ready for Review" label.

## Tomorrow (Mobile Web) Staging Verification

- Deploy the PR to the Tomorrow (Mobile Web) VP QA
  [staging environment](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StagingDeployTMWforVPQA).
- When deploy has finished, run through the
  [mobile web player core test cases](../apps/tomorrow/processes/testing-player-core.md)

## Starshot (Living Room / TV Web App) Staging Verification

- If you know ahead of time that you're opening a PR to update player-core,
  please let Ensemble know ahead of time in the
  [#emp-qa](https://twitch.slack.com/archives/G85GLRL72) Slack channel. They
  often need a day or so of lead time to begin a new test pass since testers are
  still working remotely and need to head into the office to access certain TVs.

- Deploy the PR to a Starshot (TV Web)
  [staging environment](../apps/starshot/processes/using-staging-environments.md).

- When deploy has finished, submit a ticket to QA following
  [this process](../internal-docs/processes/working-with-ensemble-qa) and let QA
  know that you want them to run through the player test cases, which should be
  based off of
  [starshot player core test cases](../apps/starshot/processes/testing-player-core.md).
  They have their own test plan spreadsheet which contains these test cases, so
  if any major app functionality has changed that requires new tests, please
  also work with QA to make sure they update their test plans.
