# Using Public Staging Environments

Tachyon has a number of public staging environments that are shared by Tomorrow,
Starshot, and Valence.

## Deploying An App Branch To Environment

1. Open the Tachyon Staging
   [Deploy App To Environment](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StagingDeployApptoEnvironmentoldpool)
   view.

1. Click the blue "..." button next to the "Deploy" button in the top right
   corner of the page. If you do not see the button, ask in #tachyon-lib-support
   to be added to the TeamCity
   [Tachyon Staging](https://teamcity.xarth.tv/admin/editGroup.html?groupCode=TACHYON_STAGING)
   group.

1. Under the "Changes" tab, select the "Build branch". If you've opened a PR for
   the branch, select using the PR format ("pull/<PR-NUMBER>") which re-uses the
   artifacts from the PR build resulting in a faster deploy time.

1. Under the "Parameters" tab, select a "Tachyon Staging Slot" that is not being
   used and the "Tachyon App" value to the app you wish to deploy.
1. Once the deploy process is completed, the deploy will be publically available
   at "https://<staging-slot-id>.tv.twitch.a2z.com".

1. Update the appropriate row in the
   [EMP Staging Slots](https://docs.google.com/spreadsheets/d/1qwl2dUEnpuPCVHaLBrV9gdT3n0ctPjYeKosxNoj8YJA/edit#gid=0)
   sheet with your name and what you're using the slot for. This is just to help
   other members of the team to know who to reach out to in case someone forgets
   to update the sheet when no longer using the slot.

## Staging Deploy Access

If you do not see a "Deploy" or "Run" button, you will need to be added to the
TeamCity
["Tachyon Staging"](https://teamcity.xarth.tv/admin/editGroup.html?groupCode=TACHYON_STAGING&item=groupUsers)"
group by an Emerging Platforms
[Lead](https://teamcity.xarth.tv/admin/editGroup.html?groupCode=EMERG_PLAT_LEADS&item=groupUsers).
Ask to be added to this group in #tachyon-lib-support.
