// We use babel plugin macros here to work with CRA. Normally you would use
// `import { graphql } from 'react-relay';` with a proper babel config.
// @ts-expect-error: no type-defs available
import graphql from 'babel-plugin-relay/macro';
import type { FC } from 'react';
import { useLazyLoadQuery } from 'react-relay/hooks';
import {
  AlignItems,
  CoreText,
  Display,
  JustifyContent,
  Layout,
} from 'twitch-core-ui';
import type { Prototype_Query } from './__generated__/Prototype_Query.graphql';

const prototypeQuery = graphql`
  query Prototype_Query {
    requestInfo {
      ipAddress
      countryCode
    }
  }
`;

export const Prototype: FC = () => {
  const data = useLazyLoadQuery<Prototype_Query>(prototypeQuery, {});

  return (
    <Layout
      alignItems={AlignItems.Center}
      display={Display.Flex}
      fullHeight
      fullWidth
      justifyContent={JustifyContent.Center}
    >
      <CoreText>
        Country: {data?.requestInfo?.countryCode ?? 'unknown'} / IP:{' '}
        {data?.requestInfo?.ipAddress ?? 'unknown'}
      </CoreText>
    </Layout>
  );
};
Prototype.displayName = 'Prototype';
