import type { FC } from 'react';
import { Suspense } from 'react';
import ReactDOM from 'react-dom';
import { RelayEnvironmentProvider } from 'react-relay/hooks';
import { CoreUiSsrRoot } from 'tachyon-more-ui';
import { configureTachyonRelay, initEnvironment } from 'tachyon-relay';
import { useConst } from 'tachyon-utils';
import { LoadingSpinner, SpinnerSize } from 'twitch-core-ui';
import { Prototype } from './Prototype';
import { CLIENT_ID } from './constants';

// /////////////////////////////////////////////////////////
// Do not edit this directly. Make changes in Prototype.tsx.
// /////////////////////////////////////////////////////////

configureTachyonRelay({ clientId: CLIENT_ID });

/**
 * Provides a basic Relay setup. Modify Prototype.tsx only.
 */
export const App: FC = () => {
  const environment = useConst(initEnvironment);

  return (
    <RelayEnvironmentProvider environment={environment}>
      <CoreUiSsrRoot appRootElementId="root">
        <Suspense
          fallback={<LoadingSpinner fillContent size={SpinnerSize.Large} />}
        >
          <Prototype />
        </Suspense>
      </CoreUiSsrRoot>
    </RelayEnvironmentProvider>
  );
};

ReactDOM.render(<App />, document.getElementById('root'));
