const { readFileSync, existsSync } = require('fs');

const validBranchNameRegExp = /([a-z]{2,}\/.+|gh-pages|publish)/;

function parseBranchName(data) {
  const match = /ref: refs\/heads\/([^\n]+)/.exec(data.toString());
  return match ? match[1] : null;
}

function gitHeadPath() {
  const headPath = '.git/HEAD';
  if (!existsSync(headPath)) {
    throw new Error('.git/HEAD does not exist');
  }
  return headPath;
}

if (!module.parent) {
  const currentBranchName = parseBranchName(readFileSync(gitHeadPath()));
  if (validBranchNameRegExp.test(currentBranchName)) {
    process.exitCode = 0;
  } else {
    process.exitCode = 1;
    console.error(`
      Current Git branch name: "${currentBranchName}"
      Branch name does not follow required format of 'namespace/branch-details'.
      See https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/ for more info.
    `);
  }
}
