// https://stylelint.io/user-guide
module.exports = {
  extends: [
    'stylelint-config-recommended',
    'stylelint-config-styled-components',
  ],
  plugins: ['stylelint-order'],
  processors: ['stylelint-processor-styled-components'],
  rules: {
    'declaration-block-trailing-semicolon': 'always',
    'order/order': [
      ['custom-properties', 'declarations', 'rules', 'at-rules'],
      { unspecified: 'bottom' },
    ],
    'order/properties-alphabetical-order': true,
    // This enables using styled components as selectors
    // https://www.styled-components.com/docs/advanced#referring-to-other-components
    'selector-type-no-unknown': [true, { ignoreTypes: ['/^-styled-mixin/'] }],
  },
};
