# Feinberg Package

Feinberg is a skeleton package for tachyon-based projects. It is named after
Gerald Feinberg who coined the term "tachyon" in his 1967 paper "Possibility of
Faster-Than-Light Particles".

# How to Use

## Process

If you are making a new package, it is often recommended to have a single
commit/PR using the setup instructions below and leaving the placeholder code
as-is, with the addition of `private: true` to your new `package.json`. This way
you are able to get all the build config etc into the repo in a straightforward
way and prevent on-going thrash of this scaffolding if any publishes happen
during your PR's review cycles (adding `private: true` prevents the package from
being published until it is actually valid). This can also make the review of
your actual logic/functionality easier as it eliminates all the noise from the
scaffolding.

## Setup

1.  Copy this folder into your team's packages directory and rename the copy to
    your package name.
1.  Replace the following strings in `package.json`:
    - REPLACE_NAME
    - REPLACE_DESCRIPTION
    - REPLACE_AUTHOR (or use the pre-filled EPEng entry which is provided for
      convenience for the most common use-case)
1.  Replace this README.
1.  Write your tests and code (or code and tests, if you prefer) - updating the
    test suite name in `src/index.test.ts`.
1.  Update Tachyon's [Changelog](../../CHANGELOG.md) with an entry for the new
    package (in alphabetical order in the pending release section), with a basic
    description of what it does, and link to the README for more details.
1.  [OPTIONAL] If you are sure your package will never be needing styles, you
    can delete the `lint:styles` and `lint:styles:ci` commands from your new
    `package.json`, as well as removing the `lint:styles` entry at the end of
    the `lint` command.

## Adding dependencies to your package

This monorepo is setup to provide packages with all of the basic development
dependencies from the workspace root, meaning you don't need to declare them as
devDependencies yourself. This includes fully configured babel, enzyme, jest +
faker, prettier, eslint, typescript, and webpack. It also includes a version of
react for local dev, but if your library uses react you'll also need to add it
as a peer dependency so that consumers will know to provide it. If for some
reason you need different versions of any of the provided libraries, please chat
with the Emerging Platforms team.

For adding normal remote dependencies, you can use `yarn add`, `yarn remove`,
etc from your package directory. Lerna does not effect this process.

If you need a dependency that is already in-use in another package, you should
either use the version that is already present in the monorepo, or if you need a
newer version you should consider updating the other packages (especially if
it's a safe update like a patch update or a non-contentious minor update).
Otherwise you can run the risk of causing multiple versions of a dependency to
wind up in application bundles. If you need a version bump but don't feel
confident bumping other packages at the same time, contact the mobile web
platform team for help.

## Adding as a dependency for another package

We support using lerna to do development inside of the monorepo without having
to publish new versions of the package. The way you can do this is to have lerna
include the local package for you. From the root tachyon directory:

```
yarn lerna add --scope=destination-package source-package [--dev]
```

This will add `source-package` to the `destination-package` dependencies; add
`--dev` if you want it to be a dev dependency (lerna doesn't understand `-D`).

## Building a new version

Any time you want to build a new version you can simply run `yarn build` in your
package. Use `yarn build:watch` for continuous rebuild-on-change. Both methods
will result in the new build being instantly updated for any consuming packages.

## Testing your package

The default configuration allows you to run tests via `yarn test` or
`yarn test:watch` and you can run the full CI suite via `yarn ci`.

## Versioning packages

Lerna will manage your package's version during publishing, so you shouldn't
modify the version value of your package manually. By default, all packages and
apps in the monorepo will use the current version of each package's code whether
or not those changes have been published. This should not be changed without
extremely good reasoning, as this can lead to dependency duplication in app
bundles. As this is a monorepo, all of the packages are supposed to work with
each other.

If an app needs to fall off of the current version of the monorepo packages, it
can so simply by declaring version needs less than the current version, which
will cause lerna/yarn to fetch the previously published versions of those
packages.

## Publishing

By default, only the files in the `dist`, `build`, and `lib` directories and the
README file will be published to the registry to minimize package size and
unnecessary files. This mirrors the default build setup as well, but if you need
to include extra files you will need to augment the `files` entry in your
package's `package.json`.

To set yourself up to publish packages, follow the
[devtools guide](https://git.xarth.tv/dta/docs/blob/master/npm.md).
