# Getting Started in Windows

Disclaimer: Tachyon does not officially support Windows. This setup process is
community maintained.

To set up Tachyon in Windows, you will need to manually install the same
packages that are in `./scripts/setup` for the base project as well as any apps
you are working on. Each `./app/<project>` has its own `setup` script you will
also need to step through.

## Setting up base Tachyon

These are the steps to reproduce `./scripts/setup`. Note we do not install
`brew` or `caskroom`.

1. Install NVM for Windows
   1. Uninstall current `node.js`
   2. Download and install the latest
      [NVM for Windows](https://github.com/coreybutler/nvm-windows) build
   3. Install and use the node version that matches the `engines` in
      [package.json](./package.json)
      ```
      "engines": {
          "node": "~14.15.0",
          "yarn": "^1.22.10"
      },
      ```
      For example, if your `package.json` has the above, you should run:
      ```
      nvm install 14.15.0
      nvm use 14.15.0
      ```
   4. Reinstall yarn (`npm install --global yarn`)
2. Install Docker for Windows
   1. Follow the
      [Install Docker Desktop on Windows instructions](https://docs.docker.com/docker-for-windows/install/#install-docker-desktop-on-windows)
   2. Start Docker
   3. (optional) You can go through the Quick Start guide to ensure things are
      running properly. If you run into a problem with port 80 being occupied,
      you can run `net stop http` in an admin terminal.
3. Install Hostess and add to PATH
   1. Download the latest build for Windows from the
      [releases](https://github.com/cbednarski/hostess/releases). The file name
      should be `hostess_windows_amd64.exe`
   2. Add `hostess` to PATH
      ([detailed instructions](#storing-executables-and-adding-to-path)) You may
      need to rename the file to `hostess.exe`
4. Install Watchman
   1. Download the latest build for Windows from the
      [releases](https://github.com/facebook/watchman/releases). The file name
      should be `watchman-vXXX-windows.zip`. Some of the releases do not have
      Windows builds.
      [Latest Windows Build as of 7/19/2021](https://github.com/facebook/watchman/releases/tag/v2021.01.04.00)
   2. Add `watchman` to PATH
      ([detailed instructions](#storing-executables-and-adding-to-path))
5. Setup and build using Yarn
   ```sh
   $ yarn install && yarn build
   ```
6. Run setup for your individual apps

## Setting up apps

Each app has its own setup script. This steps through how to do this manually on
Windows, using Moonbase
([apps/moonbase/scripts/setup](./apps/moonbase/scripts/setup)) as an example.

1. Run hostess commands
   1. Open a terminal as an Admin.
   2. Run the hostess commands in the script, leaving out the `sudo`. For
      Moonbase:
      ```
      hostess add localhost.appeals.twitch.tv 127.0.0.1
      hostess add localgql.appeals.twitch.tv 127.0.0.1
      ```
2. Setup a certificate
   1. Open the `proxy/addCert` script. For Moonbase, this is located at
      [apps/moonbase/proxy/addCert](./apps/moonbase/proxy/addCert).
   2. Run the `openssl` command that is listed in that script. Newlines may not
      work, so you have to replace the `\ <newline>` with spaces. For Moonbase,
      this is
      ```
      cd apps/moonbase/proxy
      openssl req -newkey rsa -config moonbase.conf -x509 -days 365 -out moonbase.crt
      ```
   3. Follow steps 1-6 of
      [View certificates in the MMC snap-in](https://docs.microsoft.com/en-us/dotnet/framework/wcf/feature-details/how-to-view-certificates-with-the-mmc-snap-in#view-certificates-in-the-mmc-snap-in)
      instructions to view Local computer certificates.
   4. Expand the `Certificates (Local Computer)` node, then right-click
      `Trusted Root Certification Authorities` folder and click
      `All Tasks > Import`.
   5. Follow the wizard to import the `.crt` file from your app's `proxy`
      folder, e.g. `moonbase.crt`.
   6. Verify you have a `.crt` and `.key` file in your `proxy` folder.
3. Install any app-specific executables
   1. Moonbase has no app-specific executables.
4. Build Docker container
   1. `cd` into your app, e.g. `cd apps/moonbase`
   2. Run `yarn proxy:build`
   3. In your Docker for Windows you should see a new container that has your
      app name, e.g. `moonbase-proxy`. Note: if you get an error about port 80
      being occupied, run `net stop http` in an admin terminal.

## Running Apps

Once you are setup, you can now run your app!

1. Start Docker.
   1. Run Docker for Windows
   2. Find the container for your app (should be `<app>-proxy`) and press the
      play button. If your container is not in the list, run `yarn proxy:start`.
   3. If you get an error about port 80 being occupied, run `net stop http` in
      an admin terminal.
2. Start the app.
   ```
   yarn start:windows
   ```

## Storing Executables and Adding to PATH

For Tachyon setup, you will need to store a few executables and add them to your
PATH. Here are step by step for how to do this:

1. Download the zip and extract the whole folder.
2. Open File Explorer and type `%LOCALAPPDATA%` in the address bar. This should
   bring you to `C:\Users\<user>\AppData\Local`.
3. Create a folder with the name of your package, e.g. `hostess` or `watchman`
   etc.
4. Copy/paste your downloaded executable (`.exe`) in the new folder. If there is
   a `bin` folder, you can copy the whole folder here.
5. Open the Windows menu and type `Edit the system environment variables`, you
   should open a prompt for System Properties.
6. Click `Advanced > Environment Variables > Path > Edit`.
7. Add a `New` path entry `%USERPROFILE\AppData\Local\<your folder name>` or
   `%USERPROFILE\AppData\Local\<your folder name>\bin`
8. Restart your terminals (might need to restart your computer) in order for the
   new PATH variable to show up. You can verify with `<package-name> -v` (e.g.
   `hostess -v`).
