
job {
    name "mobile-web-tracker"
    using 'TEMPLATE-autobuild'
    logRotator {
        daysToKeep(14)
    }
    scm {
        git {
            remote {
                github 'mobile-web/tracker', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'rm -rf .manta/'
        shell "manta -v -proxy"
        saveDeployArtifact 'mobile-web/tracker', '.manta'
    }
    throttleConcurrentBuilds {
      maxPerNode 2
    }
    wrappers {
      colorizeOutput(colorMap = 'xterm')
    }
}