// Karma configuration
// Generated on Wed Jun 08 2016 15:36:58 GMT-0500 (CDT)

const path = require('path');

module.exports = function(config) {
  config.set({

    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: '',


    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['systemjs', 'jasmine'],


    // list of files / patterns to load in the browser
    files: [
      'src/*.ts',
      'src/**/*.ts',
      'spec/*.ts',
      'spec/**/*.ts'
    ],


    // list of files to exclude
    exclude: [
    ],

    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {},

    systemjs: {
      // Use the main config so we don't unnecessarily deviate in tests.
      configFile: './system.conf.js',
      // Make sure Karma hosts the node modules so they can be properly loaded.
      serveFiles: ["node_modules/**/*.js"],
      config: {
        packages: {
          'spec': {
            defaultExtension: 'ts'
          },
          'src': {
            defaultExtension: 'ts'
          },
        },
        transpiler: 'typescript',
      },
    },


    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['progress', 'junit'],
    junitReporter: {
        outputFile: path.join(__dirname, '/test-results.xml'),
    },


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,


    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['PhantomJS'],


    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: false,

    // Concurrency level
    // how many browser should be started simultaneous
    concurrency: Infinity
  })
}
