import MultiLogger from "src/logger/multiLogger";

describe("MultiLogger", () => {
  it("logs to each logger", () => {
    let MESSAGE = "hello";
    let PARAMS = {world: true};
    let spy1 = jasmine.createSpyObj("MockLogger1", ["logEvent"]);
    let spy2 = jasmine.createSpyObj("MockLogger2", ["logEvent"]);

    let subject = new MultiLogger([spy1, spy2]);

    subject.logEvent(MESSAGE, PARAMS);

    expect(spy1.logEvent).toHaveBeenCalledWith(MESSAGE, PARAMS);
    expect(spy2.logEvent).toHaveBeenCalledWith(MESSAGE, PARAMS);
  });
});
