import ILogger from "./ilogger";
import assign from "lodash.assign";

export const URL = "http://api.mixpanel.com/track/";
export const PARAMETER_NAME = "data";
export const MIXPANEL_TOKEN = "809576468572134f909dffa6bd0dcfcf";

export class MixPanelLogger implements ILogger {
  logEvent(event: String, properties: Object) {
    let data = {event: event, properties: {}};
    data.properties = assign({token: MIXPANEL_TOKEN}, properties);
    let paramString = btoa(JSON.stringify(data));

    fetch(`${URL}?${PARAMETER_NAME}=${paramString}`);
  }
}