import ILogger from "./ilogger";

export default class MultiLogger implements ILogger {
  constructor(private loggers: ILogger[]) {
  }

  logEvent(event: String, properties: Object) {
    this.loggers.forEach((logger) => {
      logger.logEvent(event, properties);
    });
  }
}
