import ILogger from "./ilogger";
import assign from "lodash.assign";

export const SPADE_URL = "https://spade.twitch.tv";
export const SPADE_PARAMETER = "data";

export class SpadeLogger implements ILogger {
  logEvent(event: String, properties: Object) {
    let paramString = btoa(
      JSON.stringify(assign({}, {event: event}, properties))
    );
    fetch(`${SPADE_URL}?${SPADE_PARAMETER}=${paramString}`);
  }
}