#!/bin/bash
set -e
set -x

JOB_NAME=salt
BEBO_ENV=local

docker rm -f ${JOB_NAME} || true

docker build -t ${JOB_NAME}:${BEBO_ENV} --rm --build-arg "BEBO_VERSION=$(date +%s)" .

docker run --rm \
    --network="host" \
    --name ${JOB_NAME} \
    -e "BEBO_ENV=${BEBO_ENV}" \
    -v /srv/salt:/srv/salt \
    --user $(id -u docker) \
    ${JOB_NAME}:${BEBO_ENV}
