#!/usr/bin/env python3
# vim set sw=4 ts=4 et :

import logging
import socket

log = logging.getLogger(__name__)

def get_fqdn():
    return socket.getfqdn()

def get_domain():
    return '.'.join(get_fqdn().split('.')[1:])

def main():
    grains = {
        }
    node_name = get_fqdn().split('.')[0]
    domain = get_domain()
    split = domain.split('.')
    if 'aws' in domain:
        grains['private_domain'] = domain
        grains['public_domain'] = '.'.join(filter(lambda elem: elem != 'aws', split))
    else:
        grains['public_domain'] = domain
        split.insert(1, 'aws')
        grains['private_domain'] = '.'.join(split)


    grains['private_hostname'] = node_name + '.' + grains['private_domain']
    grains['public_hostanme'] = node_name + '.' + grains['public_domain']

    try:
        grains['service'] = '-'.join(grains['private_domain'].split('-')[1:-2]) #account for wall-e, or non-hypthenated service names
    except (KeyError, IndexError):
        pass

    return grains

if __name__ == '__main__':
    print(main())
