#!/usr/bin/env python

import requests

bebo_env = {}

def bebo_env_grains():
  instance_id_request = requests.get('http://169.254.169.254/latest/meta-data/instance-id')
  if instance_id_request.status_code == 200:
    bebo_env['INSTANCE_ID'] = instance_id_request.text

  bebo_env['AvailabilityZone'] = requests.get("http://169.254.169.254/latest/meta-data/placement/availability-zone").text
  #bebo_env['Region'] = requests.get("http://169.254.169.254/latest/meta-data/placement/availability-zone").text[:-1]
  bebo_env['mac_address'] = requests.get('http://169.254.169.254/latest/meta-data/mac').text
  bebo_env['VpcId'] = requests.get('http://169.254.169.254/latest/meta-data/network/interfaces/macs/{}/vpc-id'.format(bebo_env['mac_address'])).text
  bebo_env['Region'] = bebo_env['AvailabilityZone'][:-1]
  public_ipv4_request = requests.get('http://169.254.169.254/latest/meta-data/network/interfaces/macs/{}/public-ipv4s'.format(bebo_env['mac_address']))
  if public_ipv4_request.status_code == 200:
    bebo_env['PUBLIC_IPV4'] = public_ipv4_request.text

  return bebo_env

if __name__ == "__main__":
  bebo_env_grains()
