#!/usr/bin/env python3
# vim set sw=4 ts=4 et :

import logging
import requests
from subprocess import PIPE, Popen
import json

log = logging.getLogger(__name__)


def _get_vpc():
    mac_address = requests.get("http://169.254.169.254/latest/meta-data/network/interfaces/macs").text
    return requests.get("http://169.254.169.254/latest/meta-data/network/interfaces/macs/%s/vpc-id" % mac_address).text

def vpc_tags():
    my_az = requests.get("http://169.254.169.254/latest/meta-data/placement/availability-zone").text
    my_region = my_az[:-1]
    command = ['aws', 'ec2', '--region', my_region, 'describe-vpcs', '--vpc-ids', _get_vpc()]
    proc = Popen(command, stdout=PIPE)
    out, err = proc.communicate()
    if err:
        log.exception('Failed to describe vpc: %s' % err)
        return None
    if not out:
        log.warn('no output from describe-vpcs command?')
        return None
    out = out.decode('utf-8')
    vpc = json.loads(out)
    try:
        tags = vpc['Vpcs'][0]['Tags']
    except KeyError:
        return None

    vpc_tags = {}
    for tag in tags:
        key = tag['Key'].encode('utf-8')
        value = tag['Value'].encode('utf-8')
        vpc_tags[key] = value

    ret = dict(vpc_tags=vpc_tags)
    return ret


if __name__ == '__main__':
    print(vpc_tags())
