include:
  - core.python3
  - core.docker
  - admin.etcd_inserter

docker-py:
  cmd.run:
    - name: /usr/bin/python3 -m pip install docker
    - unless: /usr/bin/python3 -m pip freeze | grep docker
    - require:
      - pkg: python3_pkgs

etcd:
#  docker_container.running: <-- this requires the docker-py to be installed BEFORE we apply. not going to work for us
  cmd.run:
    - name: docker rm -f etcd; docker run -d --rm --network host -v /data/etcd:/data/etcd -e "ETCD_ADVERTISE_CLIENT_URLS=http://{{ grains["vpc_tags"]["Name"] }}-admin-000.{{ grains["private_domain"] }}:2739" -e "ETCD_LISTEN_CLIENT_URLS=http://0.0.0.0:2379" -e "ETCD_DATA_DIR=/data/etcd" --name etcd quay.io/coreos/etcd:v3.1 && /usr/local/bin/etcd_inserter.py --no-loop
    - require:
      - docker_pkg
      - /data/etcd
      - /usr/local/bin/etcd_inserter.py

/data/etcd:
  file.directory:
    - clean: True
