include:
  - core.python3

/usr/local/bin/etcd_insert.py:
  file.absent

/usr/local/bin/etcd_inserter.py:
  file.managed:
    - name: /usr/local/bin/etcd_inserter.py
    - source: salt://admin/files/etcd_inserter.py
    - mode: 0750
    - user: root
    - group: deploy
    - reload_grains: True
    - require:
       - sls: core.python3

etcd_inserter-service:
  file.managed:
    - name: /etc/systemd/system/etcd_inserter.service
    - source: salt://admin/files/etcd_inserter.service
  service.running:
    - name: etcd_inserter.service
    - enable: True
    - require:
       - /usr/local/bin/etcd_inserter.py
    - watch:
       - /usr/local/bin/etcd_inserter.py
