include:
  - core

docker_requisite_pkgs:
  pkg.installed:
    - refresh: True
    - pkgs:
      - apt-transport-https
      - ca-certificates
      - curl
      - gnupg2
      - software-properties-common

{% set distro = grains["lsb_distrib_id"].lower() %}

docker_repo:
  pkgrepo.managed:
    - humanname: docker repo
    - name: deb [arch=amd64] https://download.docker.com/linux/{{ distro }} {{ grains["lsb_distrib_codename"] }} stable
    - dist: {{ grains["lsb_distrib_codename"] }}
    - file: /etc/apt/sources.list.d/docker.list
    - key_url: https://download.docker.com/linux/{{ distro }}/gpg

docker_pkg:
  pkg.installed:
    - refresh: True
    - pkgs:
      - docker-ce
    - version: "18.09.5~3-0~{{ distro }}-{{ grains['lsb_distrib_codename'] }}"
    - require:
      - docker_repo
      - docker_requisite_pkgs

add_sudo_users_to_docker:
  cmd.run:
    - name: for u in $(awk -F':' '/sudo/{print $4}' /etc/group | sed 's/,/ /g'); do adduser $u docker; done
    - require:
      - docker_pkg
