include:
  - users
  - deploy
  - .python3
  - .nodejs
  - .iptables
  - .no_rsyslog

{% set distro = grains["lsb_distrib_id"].lower() %}
{%- set osversion = grains["osrelease"] -%}

{%- if distro == "debian" -%}
{%- set osversion = grains["osmajorrelease"] -%}
{%- endif %}

unattended-upgrades:
  pkg.removed

virtualenv:
  pkg.installed

apt-transport-s3:
    pkg.installed

jq:
    pkg.installed

/etc/vim/vimrc.local:
  file.absent

/etc/systemd/system/route53.service:
  file.absent

/etc/vim/vim.local:
  file.absent

neovim:
  pkg.installed

add-gpg-key:
  cmd.run:
    - name: 'curl https://repo.saltstack.com/apt/debian/9/amd64/latest/SALTSTACK-GPG-KEY.pub | apt-key add -'
    - onlyif: 'test -z "`apt-key list | grep saltstack`"'

/etc/apt/sources.list.d/saltstack_debian_repo.list:
    file.absent

saltstack_repo:
  pkgrepo.managed:
    - humanname: saltstack repo
    - name: deb http://repo.saltstack.com/apt/{{ distro }}/{{ osversion }}/amd64/archive/2018.3.2 {{ grains["lsb_distrib_codename"] }} main
    - dist: {{ grains["lsb_distrib_codename"] }}
    - file: /etc/apt/sources.list.d/saltstack_repo.list
    - order: 1

# salt-minion backup config
/etc/salt/minion.d/backup.conf:
  file.managed:
    - contents: "# managed by salt, do not change locally"
    - contents: "backup_mode: minion"

blab_apt_repo:
  pkgrepo.absent:
    - file: /etc/apt/sources.list.d/apt.blab.im.list

base_packages:
  pkg.installed:
    - pkgs:
      - byobu
      - command-not-found
      - curl
      - dnsutils
      - dstat
      - git
      - htop
      - libpam-google-authenticator
      - libpam-systemd
      - locate
      - lsof
      - ngrep
      - ntp
      - ntpdate
      - ntpstat
      - python-pip
      - ruby
      - silversearcher-ag
      - strace
      - sudo
      - sysfsutils
      - sysstat
      - tshark
      - unzip
      - xinetd
      - zsh

/etc/default/sysstat:
  file.managed:
    - contents: "# managed by salt, do not change locally"
    - contents: "ENABLED='true'"

sysstat-service:
  service.running:
    - name: sysstat
    - enable: True

set_ssh_2_factor_auth:
  file.replace:
    - name: /etc/ssh/sshd_config
    - pattern: ^ChallengeResponseAuthentication no
    - repl: ChallengeResponseAuthentication yes

/etc/pam.d/sshd:
  file.append:
    - text:
      - "# google authenticator"
      - auth required pam_google_authenticator.so

ssh:
  service.running:
    - enable: True
    - reload: True
    - watch:
      - file: /etc/ssh/sshd_config

/data:
  file.directory:
    - mode: 0755

/etc/cron.d/reboot:
  file.managed:
    - source: salt://core/files/reboot.cron

/usr/local/sbin/ec2-hostname.sh:
  file.managed:
    - source: salt://core/files/ec2-hostname.sh.jinja
    - template: jinja
    - user: root
    - mode: 0500

update_hostname:
  cmd.run:
    - name: /usr/local/sbin/ec2-hostname.sh
    - require:
      - file: /usr/local/sbin/ec2-hostname.sh
      - sls: users.deploy
      - base_packages
      - awscli_python3
    - reload_grains: true

# set aws cloud init to keep hostname on reboot
/etc/cloud/cloud.cfg:
  file.replace:
    - pattern: 'preserve_hostname: false'
    - repl: 'preserve_hostname: true'
    - append_if_not_found: True

/etc/network/if-up.d/add_route53.py:
  file.absent

/etc/network/if-down.d/delete_route53.py:
  file.absent

/etc/rc.local:
  file.managed:
    - source: salt://core/files/rc.local
    - mode: 0755

/usr/local/sbin/bebo_route53.py:
  file.managed:
    - source: salt://core/files/bebo_route53.py
    - user: root
    - group: root
    - mode: 0755

run-bebo-route53:
  cmd.run:
    - name: python3 /usr/local/sbin/bebo_route53.py start
#TODO figure out how to pass stop to this
    - require:
      - sls: core.python3
      - /usr/local/sbin/bebo_route53.py
      - update_hostname

/var/crash:
  file.directory:
    - mode: 2777
    - group: staff

kernel.core_pattern:
  sysctl.present:
    - value: /var/crash/%e.%p.%t

restart_ntp:
  cmd.run:
    - name: /bin/systemctl restart ntp
    - onchanges:
      - file: /etc/ntp.conf

/etc/ntp.conf:
  file.managed:
    - source: salt://core/files/ntp.conf
