{%- set master = grains["master"].split(":")[0] -%}


{%- if "-admin-" not in grains["id"] -%}
etcd-iptables:
  iptables.insert:
    - position: 1
    - table: nat
    - chain: OUTPUT
    - jump: DNAT
    - family: ipv4
    - proto: tcp
    - dport: 2379
    - to-destination: {{ master }}:2379

masquerade:
  iptables.insert:
    - position: 1
    - table: nat
    - chain: POSTROUTING
    - jump: MASQUERADE
    - source: 127.0.0.1/16
    - destination: {{ master }}/16

del_old_masquearde:
  iptables.delete:
    - table: nat
    - chain: POSTROUTING
    - jump: MASQUERADE
    - source: 0.0.0.0/0
    - destination: 0.0.0.0/0

{%- else -%}

masquerade:
  iptables.insert:
    - position: 1
    - table: nat
    - chain: POSTROUTING
    - jump: MASQUERADE

{%- endif %}

net.ipv4.conf.all.route_localnet:
  sysctl.present:
    - value: 1

net.ipv4.ip_forward:
  sysctl.present:
    - value: 1
