# nodejs package from nodesource.com
nodesource:
  file.absent:
    - name: /etc/apt/sources.list.d/nodesource.list

nodejs_absent:
  file.absent:
    - name: /etc/apt/sources.list.d/nodejs.list

nodesourcejs:
  pkgrepo.managed:
    - humanname: nodesource repo
    - name: deb https://deb.nodesource.com/node_6.x {{ grains["lsb_distrib_codename"] }} main
    - dist: {{ grains["lsb_distrib_codename"] }}
    - file: /etc/apt/sources.list.d/nodejs_6.list
    - key_url: https://deb.nodesource.com/gpgkey/nodesource.gpg.key

nodejs:
  pkg.installed:
    - refresh: True
    - allow_updates: True
    - require:
      - pkgrepo: nodesourcejs

nodejs_alternative:
  alternatives.install:
    - name: node
    - link: /usr/bin/node
    - path: /usr/bin/nodejs
    - priority: 10
    - require:
      - pkg: nodejs
