include:
  - core

python3_pkgs:
  pkg.installed:
    - pkgs:
      - libpython3-dev
      - python3
      - python3-dev
      - python3-venv
      - python3-pip
      - python3-setuptools
      - python3-wheel
      - python3-distlib
      - python3-html5lib
    - reload_modules: True
    - refresh: True

colorama_pip3:
  cmd.run:
    - name: /usr/bin/python3 -m pip install colorama
    - unless: /usr/bin/python3 -m pip freeze | grep colorama
    - require:
      - pkg: python3_pkgs

boto3_python3:
  cmd.run:
    - name: /usr/bin/python3 -m pip install boto3
    - unless: /usr/bin/python3 -m pip freeze | grep boto3
    - require:
      - colorama_pip3

python-etcd_python3:
  cmd.run:
    - name: /usr/bin/python3 -m pip install git+https://github.com/bebo/python-etcd@0.4.6
    - unless: /usr/bin/python3 -m pip freeze | grep python-etcd
    - require:
      - pkg: python3_pkgs

awscli_python3:
  cmd.run:
    - name: /usr/bin/python3 -m pip install awscli
    - unless: /usr/bin/python3 -m pip freeze | grep awscli
    - require:
      - pkg: python3_pkgs
