include:
  - sudo.deploy
  - core
  - core.docker
  - core.python3

ruby-typhoeus:
  pkg.installed

/usr/local/bin/boto_deploy:
  file.absent

docker_deploy-runner:
  file.absent:
    - names:
      - /usr/local/bin/docker_deploy_runner.py

docker_deploy:
  file.managed:
    - name: /usr/local/bin/docker_deploy.py
    - source: salt://deploy/files/docker_deploy.py
    - mode: 0750
    - user: root
    - group: deploy
    - reload_grains: True
    - require:
       - pkg: docker_pkg
       - pkg: python3_pkgs
       - python-etcd_python3
       - run-bebo-route53

docker_deploy-service:
  file.managed:
    - name: /etc/systemd/system/docker_deploy.service
    - source: salt://deploy/files/docker_deploy.service
  service.running:
    - name: docker_deploy.service
    - enable: True
    - require:
       - docker_deploy
       - update_hostname
    - watch:
       - docker_deploy
       - update_hostname
    - onlyif: 'test ! -f /etc/dev_box'

/usr/local/bin/activate:
  file.absent

/data/build:
  file.directory:
    - user: deploy
    - require:
      - file: /data
{% if 'jenkins' in grains['id'] %}
    - group: jenkins
    - mode: 0775
{% endif %}

/srv/www:
  file.directory:
    - name: /srv/www
    - group: deploy
    - mode: 0775

/etc/sudoers.d/10-deploy:
  file.absent

find /data/build -type f -mtime +1 -delete:
  cron.present:
    - user: deploy
    - hour: 0

/usr/share/deploy/bin:
  file.directory:
    - user: deploy
    - group: deploy

{% set username_command = 'aws ssm get-parameter --region ' + grains["Region"] + ' --name /' + grains["vpc_tags"].get("BEBO_ENV", "dev") + '/aws-saltstack/DOCKER_DEPLOY_USERNAME --with-decrypt --query Parameter.Value | jq -r \'. | fromjson\'' -%}
{%- set password_command = 'aws ssm get-parameter --region ' + grains["Region"] + ' --name /' + grains["vpc_tags"].get("BEBO_ENV", "dev") + '/aws-saltstack/DOCKER_DEPLOY_PASSWORD --with-decrypt --query Parameter.Value | jq -r \'. | fromjson\'' -%}


docker-login:
  cmd.run:
    - name: "echo $({{password_command}}) | docker login -u $({{username_command}}) --password-stdin"
    - unless: "docker info | grep Username | grep $({{username_command}})"
    - require:
      - docker_pkg
      - jq
      - awscli_python3
