include:
 - users.docker

dispatcher_dir:
  file.directory:
    - name: /data/dispatcher
    - user: docker
    - recurse:
        - user
    - require:
        - docker_user

{%- if 'xvdb' in salt['grains.get']('SSDs') %}
/dev/xvdb:
  blockdev.formatted:
    - fs_type: ext4

/data/dispatcher:
  mount.mounted:
    - device: /dev/xvdb
    - fstype: ext4
    - dump: 0
    - persist: True
    - pass_num: 1
    - opts:
      - defaults
      - nofail
    - require:
      - blockdev: /dev/xvdb
      - file: /data/dispatcher
{%- endif %}
