include:
  - nginx
  - jenkins.docker

jenkins_repo:
    pkgrepo.managed:
        - humanname: Jenkins upstream package repository
        - name: deb http://pkg.jenkins.io/debian-stable binary/
        - file: /etc/apt/sources.list.d/jenkins.list
        - key_url: https://pkg.jenkins.io/debian/jenkins-ci.org.key

jenkins_build_requirements:
    pkg.installed:
        - pkgs:
            - flex
            - libbison-dev
            - liborc-0.4-dev
            - nasm
sass:
  gem.installed:
    - version: 3.4.13

slack-poster:
    gem.installed

jenkins:
    pkg.installed:
        - version: 2.121.3
    require:
        - pkgrepo: jenkins_repo
        - pkg: jenkins_build_requirements

ruby:
    pkg.installed

maven:
    pkg.installed


/etc/nginx/conf.d/jenkins.vhost:
  file.managed:
    - source: salt://jenkins/files/jenkins.vhost.jinja
    - template: jinja

/usr/local/bin/jenkins_uploader:
  file.absent

/usr/local/bin/etcd_updater:
  file.managed:
    - source: salt://jenkins/files/etcd_updater.py
    - mode: 0755
