{% if 'bebo-dev.com' in grains['id'] or 'dev.aws.blab.im' in grains['id'] -%}
  {% set cert = 'bundle-star.bebo-dev.com.crt' -%}
  {% set key = 'star.bebo-dev.com.key' -%}
{% elif 'bebo-ptr.com' in grains['id'] -%}
  {% set cert = 'bundle-star.bebo-ptr.com.crt' -%}
  {% set key = 'star.bebo-ptr.com.key' -%}
{% elif 'bebo.com' in grains['id'] -%}
  {% set cert = 'bundle-star.bebo.com.crt' -%}
  {% set key = 'star.bebo.com.key' -%}
{% endif -%}

nginx_ssl_dir:
  file.directory:
    - name: /etc/nginx/ssl
    - makedirs: True

nginx_ssl_cert:
 file.managed:
   - source: salt://ssl/{{ cert }}
   - name: /etc/nginx/ssl/{{ cert }}
   - mode: 0600
   - require:
     - file: nginx_ssl_dir

nginx_ssl_key:
 file.managed:
   - source: salt://ssl/{{ key }}
   - name: /etc/nginx/ssl/{{ key }}
   - mode: 0600
   - require:
     - file: nginx_ssl_dir

/usr/bin/openssl dhparam -out /etc/nginx/ssl/dhparam.pem 2048:
  cmd.run:
    - unless: test -f /etc/nginx/ssl/dhparam.pem
    - require:
      - file: /etc/nginx/ssl

/etc/nginx/ssl/dhparam.pem:
  file.managed:
    - replace: False
    - user: root
    - group: root
    - mode: 0600
    - create: False
