include:
  - core
  - .certs

{% set distro = grains["lsb_distrib_id"].lower() %}

nginx.repo:
  pkgrepo.managed:
    - humanname: nginx
    - name: deb http://nginx.org/packages/mainline/{{ distro }}/ {{ grains["lsb_distrib_codename"] }} nginx
    - file: /etc/apt/sources.list.d/nginx.list
    - key_url: salt://nginx/files/nginx_signing.key

/lib/systemd/system/nginx.service:
  file.managed:
    - user: root
    - group: root
    - source: salt://nginx/files/nginx.service

/var/log/nginx:
  file.directory:
    - makedirs: True

/var/log/nginx/access.log:
  file.managed:
    - user: root
    - group: root
    - require:
        - file: /var/log/nginx

/var/log/nginx/error.log:
  file.managed:
    - user: root
    - group: root
    - require:
        - file: /var/log/nginx

/etc/nginx:
  file.directory

/etc/nginx/conf.d:
  file.directory:
    - clean: True
    - require:
        - file: /etc/nginx

/etc/nginx/mime.types:
  file.managed:
    - source: salt://nginx/files/mime.types
    - require:
        - file: /etc/nginx/conf.d


/etc/nginx/nginx.conf:
  file.managed:
    - source: salt://nginx/files/nginx.conf
    - require:
        - file: /etc/nginx/conf.d

apt_nginx:
  pkg.installed:
    - pkgs:
        - nginx
    - require:
        - pkgrepo: nginx.repo

/usr/sbin/nginx:
  file.exists:
    - onfail:
        - pkg: apt_nginx

nginx:
  service.running:
    - enable: True
    - require:
        - file: /usr/sbin/nginx
        - file: /etc/nginx/nginx.conf
        - file: /lib/systemd/system/nginx.service
        - file: /etc/nginx/mime.types
        - file: /var/log/nginx/error.log
        - file: /var/log/nginx/access.log
        - file: /etc/nginx/conf.d/default.conf

nginx_reload:
  cmd.run:
    - name: systemctl reload nginx
    - onchanges:
      - file: /etc/nginx/*

/etc/nginx/conf.d/default.conf:
  file.absent

/data/nginx:
  file.directory

/etc/nginx/ssl:
  file.directory:
    - require:
      - service: nginx

/etc/nginx/conf.d/log_destination_remote.vhost:
  file.managed:
    - source: salt://nginx/files/log_destination_remote.vhost
    - template: jinja
    - require:
      - service: nginx

/etc/nginx/conf.d/real_ip.vhost:
  file.managed:
    - source: salt://nginx/files/real_ip.vhost
    - require:
      - service: nginx
