rsyslog:
  pkg.installed:
    - name: rsyslog-relp
  service:
    - running
    - enable: True
    - restart: True
    - watch:
      - file: /etc/rsyslog.d/*
      - file: /etc/rsyslog.conf
      - pkg: rsyslog

/etc/rsyslog.conf:
  file.managed:
    - source: salt://rsyslog/files/rsyslog.conf

/etc/rsyslog.d:
  file.directory:
    - makedirs: True

/etc/rsyslog.d/50-default.conf:
  file.managed:
    - source: salt://rsyslog/files/50-default.conf.jinja
    - template: jinja
    - makedirs: True
    - require:
      - file: /etc/rsyslog.conf
      - file: /etc/rsyslog.d

/etc/logrotate.d/rsyslog-local:
  file.managed:
    - source: salt://rsyslog/files/rsyslog-local.logrotate
    - require:
      - file: /etc/rsyslog.d
