include:
  - rsyslog

logging:
  group.present:
    - system: True
    - addusers:
      - fpn
      - jake
      - furqan

/etc/rsyslog.d/10-server.conf:
  file.managed:
    - source: salt://rsyslog/files/10-server.conf.jinja
    - template: jinja
    - user: root
    - group: root
    - mode: 0644
    - makedirs: True
    - require_in:
      - pkg: rsyslog
      - file: /etc/rsyslog.d

/etc/logrotate.d/rsyslog-server:
  file.managed:
    - source: salt://rsyslog/files/rsyslog-server.logrotate

{% if 'xvdb' in salt['grains.get']('SSDs') %}
/dev/xvdb1:
  blockdev.formatted:
    - fs_type: ext4

syslog_dir:
  file.directory:
    - name: /srv/syslog

/srv/syslog:
  file.directory:
    - group: logging    # make sure we depend on group being here
    - recurse:
      - group
  mount.mounted:
    - device: /dev/xvdb1
    - fstype: ext4
    - dump: 0
    - pass_num: 1
    - opts:
      - defaults
      - nofail
      - noatime
    - require:
      - blockdev: /dev/xvdb1
      - file: /srv/syslog
{%- endif %}
