const AWS = require('aws-sdk');
const os = require('os');
const request  = require('request-promise');

const fqdn = os.hostname().split('.');
const hostname = fqdn[0];
const service = fqdn[1];
const region = hostname.split('-')[0];
const Promise = require('bluebird');

AWS.config.setPromisesDependency(Promise);

class Config {

  constructor() {
    this.node = os.hostname();
    this.region = this.node.split('-')[0];
    this.env = process.env.BEBO_ENV || 'local';
    console.log("ENV", this.env);
    this.REGION = region;
  }

  async getParameters(env) {
    let path = `/${env}/${this.name}/`;
    let params = {
      Path: path,
      MaxResults: 10,
      Recursive: true,
      WithDecryption: true
    }
    console.log("getting", env, "config", path);
    let nextToken = 'initialized';
    while ( nextToken != null) {
      let data = await this.ssm.getParametersByPath(params).promise();
      nextToken = data.NextToken;
      params.NextToken = nextToken;
      for (let p of data.Parameters) {
        let key = p.Name.replace(path, "");
        try {
          this[key] = JSON.parse(p.Value);
        } catch (e) {
          console.error(e, "can't parse json for key", key, p.Value);
        }
      }
    }
  }

  async init({name}) {
    this.name = name;
    this.AWS_REGION = await this.getAwsRegion();
    AWS.config.region = this.AWS_REGION;
    this.ssm = new AWS.SSM();

    if (this.isLocal() && this.env !== 'local') {
      await this.getParameters('local');
      try {
        await this.getParameters(this.env);
      } catch (err) {
        console.error("Env not in AWS", this.env, err);
      }
    } else {
      await this.getParameters(this.env);
    }
    // for (let [ k, v] of Object.entries(this)) {
    //   console.log(k, v);
    // }

    this.initialized = true;
  }

  async getAwsRegion() {
    let availabilityZone = await request(
      'http://169.254.169.254/latest/meta-data/placement/availability-zone'
    );
    return availabilityZone.substring(availabilityZone.length - 1, 0);
  };

  isProd() {
    return this.env === 'bebo-prod';
  };

  isPTR() {
    return this.env === 'ptr';
  };

  isLocal() {
    return this.env !== 'bebo-prod' && this.env !== 'dev' && this.env !== 'ptr';
  }
}

module.exports = new Config();
