const path = require('path');
const fse = require('fs-extra');
const Dispatcher = require('./new_dispatcher');
const Utils = require('./utils');
const logger = require('../Logger');

class Factory {

  constructor() {
    this.dispatchers = {};
    this.Utils = Utils;
    this.createDirectory = this.createDirectory.bind(this);
  }

  init(options) {

    this.root_path = options.DISPATCHER_PATH;
    this.verbose = options.DISPATCHER_VERBOSE;

    if (this.verbose) {
      console.log("LOGGER WTF", logger);
      logger.info(`BeboNodeCommons::DispatcherFactory:constructor root_path: ${this.root_path}`);
    }
  }

  createDirectory(dir) {
    if (this.verbose) {
      logger.info(`BeboNodeCommons::DispatcherFactory:createDirectory creating dir ${dir}`);
    }
    return fse.ensureDirSync(dir);
  }

  getInstance({ queueName, pickup_rate_ms, pickup_delay_ms }) {
    if (!queueName) {
      throw 'BeboNodeCommons::DispatcherFactory:getInstance queueName is a required param';
    }

    if (! this.root_path) {
      throw 'BeboNodeCommons::Dispatcher not initialized'
    }

    if (this.dispatchers[queueName]) {
      return this.dispatchers[queueName];
    }

    const fullPath = path.normalize(this.root_path + queueName);

    this.createDirectory(fullPath);
    this.dispatchers[queueName] = new Dispatcher(fullPath, queueName, pickup_rate_ms, pickup_delay_ms, this.verbose);
    return this.dispatchers[queueName];
  }
}

module.exports = new Factory();
