const redis = require('redis');
const bluebird = require('bluebird');

const logger = require('../Logger');
var config = require('../Config');

bluebird.promisifyAll(redis.RedisClient.prototype);
bluebird.promisifyAll(redis.Multi.prototype);

let write_clients = {};
let read_clients = {};

module.exports = {
  getReadClient: db => {
    if (!db) {
      db = config.AUTH_REDIS_DB;
    }
    if (!(db in read_clients)) {
      let read_client = redis.createClient(config.REDIS_PORT, config.REDIS_HOST_SLAVE, { db: db });
      read_client.on('error', err => {
        logger.error('Read client error. db:', db, err);
      });
      read_client.on('end', () => {
        logger.error('Read client unexpectedly ended. db:', db);
      });

      read_clients[db] = read_client;
    }

    return read_clients[db];
  },
  getWriteClient: db => {
    if (!db) {
      db = config.AUTH_REDIS_DB;
    }
    if (!(db in write_clients)) {
      let write_client = redis.createClient(config.REDIS_PORT, config.REDIS_HOST, { db: db });
      write_client.on('error', err => {
        logger.error('Write client error. db:', db, err);
      });
      write_client.on('end', () => {
        logger.error('Write client unexpectedly ended. db:', db);
      });
      write_clients[db] = write_client;
    }
    return write_clients[db];
  },
  get: key => {
    return this.getReadClient()
      .hgetall(key)
      .catch(err => {
        logger.error('error getting key: ', key, 'with error: ', err);
        return Promise.reject(err);
      });
  }
};
