const process = require('process');
const factory = require('../../src/Dispatcher');
const fs = require('fs');
const exec = require('child_process').exec;
const chai = require('chai');
const assert = chai.assert;

describe('Dispatcher', () => {

  let dispatcher;

  before(async function() {
    let config = { DISPATCHER_PATH: "/tmp/",
                   DISPATCHER_VERBOSE: true };
    await factory.init(config);
  });

  describe('Creates instance', () => {
    it('dispatcher created', async () => {
      const opts = {
        queueName: 'test',
        verbose: true
      };
      dispatcher = factory.getInstance(opts);
      assert.typeOf(dispatcher, 'object');
      assert.typeOf(dispatcher.writeEvent, 'function');
    });

  });

  describe('Writes Event', () => {
    it('writes 1 event', async () => {
      const opts = {
        queueName: 'one',
        verbose: true
      };
      const d= factory.getInstance(opts);
      await d.writeEvent({
          foo: 'bar',
          category_tx: 'test',
          action_tx: 'run',
          label_tx: 1
        });
    });
  });
});
