import os
import json
import socket

import boto3
import requests

aws_region = requests.get('http://169.254.169.254/latest/meta-data/placement/availability-zone', timeout=0.5).text[:-1]

fqdn = socket.getfqdn().split('.')
hostname = fqdn[0]
service = fqdn[1]
region = hostname.split('-')[0]

class Config(object):
    def __init__(self):
        self.ENV = os.environ.get('BEBO_ENV') or 'local'
        self.VERSION = os.environ.get('BEBO_VERSION') or 'local'
        self.HOSTNAME = hostname
        self.AWS_REGION = aws_region
        self.SERVICE = service
        self.REGION = region
        self.BLACKLISTED_KEYS = dir(self)

    def init(self, app_name):
        ssm = boto3.client("ssm", region_name=aws_region)

        def get_from_path(_env):
            next_token = "init"
            path = "/%s/%s" % (_env, app_name)

            while next_token:
                #TODO Johnny 5/17/19 -- handle exceptions for ratelimit and retry
                real_token = next_token if next_token != "init" else None
                if real_token:
                    result = ssm.get_parameters_by_path(
                        Path=path,
                        Recursive=True,
                        WithDecryption=True,
                        MaxResults=10,
                        NextToken=real_token
                    )
                else:
                    result = ssm.get_parameters_by_path(
                        Path=path,
                        Recursive=True,
                        WithDecryption=True,
                        MaxResults=10
                    )

                next_token = result.get('NextToken', None)
                for parameter in result['Parameters']:
                    name = parameter['Name']
                    k = name.split("/")[-1]
                    if k in self.BLACKLISTED_KEYS:
                        continue
                    try:
                        v = json.loads(parameter['Value'])
                        setattr(self, k, v)
                    except json.decoder.JSONDecodeError as e:
                        print("WARNING Unable to parse key %s -- %s" % (name, e))

        if self.ENV in ["local", "dev", "bebo-prod"]:
            # just do base
            get_from_path(self.ENV)
        else:
            # otherwise, do local + env
            get_from_path("local")
            get_from_path(self.ENV)

cfg = Config()
